#ifndef SST_SEP_ATP_ECCASYMAUTHENTICATOR_H
#define SST_SEP_ATP_ECCASYMAUTHENTICATOR_H
#include "SST_SEP_TST.h"
/*
 * All the includes that are needed for code using this module to
 * compile correctly should be #included here.
 */

#ifdef __cplusplus
extern "C"
{
#endif

  /*
   *  Object %name    : %
   *  State           :  %state%
   *  Creation date   : Apr 01 12:06:34 2009
   *  Last modified   :  %modify_time%
   */
  /** @file
   *  \brief A brief description of this module
   *
   *  \version SST_SEP_ATP_ECCAsymAuthenticator.h#1:incl:1
   *  \author  taniam
   *  \remarks Copyright (C) 2007 by Discretix Technologies Ltd.
   *           All Rights reserved
   */

/************************ Structs  ******************************/
typedef struct TST_ATP_ECCAuthTestDataStruct{
    char                        TST_Name[TST_NAME_STRING_LEN];
    DxUint8_t                   TST_ExternalPublKey[TST_MAX_ECC_KEY_SIZE_BYTES];
    DxUint32_t                  TST_ExternalPublKeySize;
    DxUint8_t                   TST_ExternalPrivKey[TST_MAX_ECC_KEY_SIZE_BYTES];
    DxUint32_t                  TST_ExternalPrivKeySize;
    DxByte_t                    TST_ChallengeBuff[TST_CHALLENGE_SIZE_BYTES];
    DxUint32_t                  TST_ChallengeBuffSize;  
    DxByte_t                    TST_NewChallengeBuff[TST_CHALLENGE_SIZE_BYTES];
    DxUint32_t                  TST_NewChallengeBuffSize;  
    DxByte_t                    TST_SignedChallengeBuff[TST_N_SIZE_BYTES];
    DxUint32_t                  TST_SignedChallengeBuffSize;
    DxByte_t                    TST_Data[TST_TEMP_DATA_LENGTH];
    DxUint32_t                  TST_DataSize;
} TST_ATP_ECCAuthTestDataStruct;
/*****************************************************************************
 * Function Name:
 *  SST_TST_ATP_ECCAsymAuthenticator
 * 
 * Inputs:
 *  None
 *
 * Outputs:
 *  DxError_t - Function error return
 *
 * Description:
 * Test the creation, deletion, modification, opening, closing and usage of an ECC asymmetric key authenticator object.
 * And demonstration on the use of transaction with authenticator objects.
 *  
 * Algorithm:
 *    1.  Build a Private Key using CRYS for CRYS usage by calling: CRYS_RSA_Build_PrivKey (externally generated key).
 *    2.  Create a new session by calling: SST_SessionCreate.
 *    3.  Open a transaction by calling: SST_TransactionStart.
 *    4.  Create a new asymmetric key authenticator by calling: SST_AuthenticatorPubKeyECCCreate.
 *    5.  Close the transaction by calling: SST_TransactionClose.
 *    6.  Open a transaction by calling: SST_TransactionStart.
 *    7.  Open the new authenticator by calling: 
 *        i.   SST_AuthenticatorChallengeGet 
 *        ii.  CRYS_ECDSA_Sign
 *        iii. SST_AuthenticationOpen.
 *    8.  Close the transaction by calling: SST_TransactionClose.
 *    9.  Open a transaction by calling: SST_TransactionStart.
 *    10.Insert a new data object by calling: SST_InsertData.
 *    11.Close the authenticator by calling: SST_AuthenticationClose.
 *    12.Open the authenticator by calling: 
 *        i.   SST_AuthenticatorChallengeGet 
 *        ii.  CRYS_ECDSA_Sign
 *        iii. SST_AuthenticationOpen.
 *    13. Close the transaction by calling: SST_TransactionClose.
 *    14. Open a transaction by calling: SST_TransactionStart.
 *    15. Delete the data by calling: SST_DeleteData.
 *    16. Delete the authenticator by calling: SST_AuthenticatorDelete.
 *    17. Close the transaction by calling: SST_TransactionClose.
 *    18. Delete the session by calling: SST_SessionDelete.
 *
 *******************************************************************************/
 DxError_t SEPQA_SST_ECCAsymAuthenticator ( void );

#ifdef __cplusplus
}


#endif

#endif
